#!/bin/bash

CFG_DIR="/etc/push-client/"

readarray -t configs < <(find $CFG_DIR -maxdepth 1 -type f,l -a \( -name '*.yaml' -o -name '*.yml' \))

if [[ ${#configs[@]} -eq 0 ]]; then
    # а где конфиги?
    echo "No configs found. Exit" >&2
    exit 1
fi

if [[ ${#configs[@]} -eq 1 ]]; then
    # Если конфиг один, то просто запустим push-client без затей
    echo "Starting with single config file: ${configs[0]}"
    exec /usr/bin/push-client -f -c "${configs[0]}"
fi

# Если конфигов много, то пусть push-client сам с ними разбирается
# Тут важный флаг `-w` который запускает push-client в режиме демона
# https://wiki.yandex-team.ru/logbroker/docs/push-client/multiaddress/
opts="-f -w"
for conf in "${configs[@]}"; do
    opts="$opts -c $conf"
done
echo "Starting with multiple config files: ${configs[@]}"
exec /usr/bin/push-client $opts
