#!/bin/bash

# Проверка наличия смонитрованого эфимерного диска:
function check_ephemeral() {
    mount | grep -q "/ephemeral"
}

# Симлинки каталогов с логами в эфимерный диск:
function qloud_log {
# Usage: qloud_logs foldername [user:group]
    if [ -z $1 ];then
        echo "Directory missing!"
        return 1
    fi
    rm -rf "/var/log/$1"
    mkdir -pv "/ephemeral/log/$1" || true
    ln -sfv "/ephemeral/log/$1" /var/log/
    ([[ $2 ]] && chown -Rv $2 /ephemeral/log/$1) || true

}

# Симлинки произвольных каталогов:
# Пример:
# qloud_link /var/log/app создаст:
# /var/log/app -> /ephemeral/var/log/app
function qloud_link {
# Usage: qloud_link dir($1) [user:group]($2)
    local sdir=$(echo $1 | sed 's/\/$//')
    if (file -i $sdir | grep -q "symlink"); then
        echo "Symlink already exists: "$sdir
    else
        rm -rf $sdir
        mkdir -pv "/ephemeral$sdir" || true
        ln -sfv "/ephemeral$sdir" $(dirname $sdir)
        ([[ $2 ]] && chown -Rv $2 /ephemeral$sdir) || true
    fi
}

# Симлинки на существующие каталоги c сохранением вложенных:
# Пример, для существующих каталогов /app/log/unistat:
# qloud_link /app/log создаст:
# /app/log -> /ephemeral/app/log
# с сохранением вложенного каталога unistat и всех прав
function qloud_link_recursive {
# Usage: qloud_link_recursive foldername
    local sdir=$(echo $1 | sed 's/\/$//')
    if (file -i $sdir | grep -q "symlink"); then
        echo "Symlink already exists: "$sdir
    else
        local base_dir=$(dirname $sdir)
        mkdir -pv "/ephemeral$base_dir" || true
        rsync -av $sdir "/ephemeral$base_dir"
        rm -rf $sdir
        ln -sfv "/ephemeral$sdir" $base_dir
    fi
}

function push_client_link {
    ln -svf /etc/supervisor/conf-available/push-client.conf /etc/supervisor/conf.d/
}

function monrun_prepare {
    touch /var/log/monrun.log; chown -vR monitor:monitor /var/log/monrun.log
    /usr/bin/monrun --gen-jobs
}
