#!/bin/sh

TMP="/tmp"
current_load_rx=$(cat /sys/class/net/veth0/statistics/rx_bytes)
current_load_tx=$(cat /sys/class/net/veth0/statistics/tx_bytes)

while getopts "w:c:" OPTION
do
    case $OPTION in
        w)
            WARN_LIMIT_DEF="$OPTARG"
        ;;
        c)
            CRIT_LIMIT_DEF="$OPTARG"
        ;;
    esac
done

WARN_LIMIT=${WARN_LIMIT_DEF:-60}
CRIT_LIMIT=${CRIT_LIMIT_DEF:-80}

if [ -s "/etc/default/network_usage" ]; then
	WARN_LIMIT=$(cat network_us:age_conf | grep [az] -v |  awk -F" " '{ print $1 }')
	CRIT_LIMIT=$(cat network_usage_conf | grep [az] -v |  awk -F" " '{ print $2 }')
fi

if [ -s "$TMP/if_load_old_temp.rx" ]; then
        old_load_rx=$(cat "$TMP/if_load_old_temp.rx")
    else
        old_load_rx=0
fi

echo "$current_load_rx" > "$TMP/if_load_old_temp.rx"


if [ -s "$TMP/if_load_old_temp.tx" ]; then
        old_load_tx=$(cat "$TMP/if_load_old_temp.tx")
    else
        old_load_tx=0
fi

echo "$current_load_tx" > "$TMP/if_load_old_temp.tx"

deltaload_rx=$(( current_load_rx - old_load_rx ))
deltaload_tx=$(( current_load_tx - old_load_tx ))

QLOUD_BANDWIDTH_LIMIT=$(qloud_var QLOUD_BANDWIDTH_LIMIT)
minute_traffic=$(( QLOUD_BANDWIDTH_LIMIT * 60 / 8 )) # In bytes per minute

load_perc_rx=$(( (deltaload_rx * 100)  / minute_traffic ))
load_perc_tx=$(( (deltaload_tx * 100)  / minute_traffic  ))

if [ $load_perc_rx  -gt $CRIT_LIMIT ]  ||  [ $load_perc_tx  -gt $CRIT_LIMIT ]; then
        status=2
elif [ $load_perc_rx  -gt $WARN_LIMIT ]  || [ $load_perc_tx  -gt $WARN_LIMIT ]; then
        status=1
else
        status=0
fi

echo "$status;rx=$load_perc_rx%, tx=$load_perc_tx%"
