#!/bin/sh

crit_flag=0
warn_flag=0
message=""

die () {
        echo "$1;$2"
        exit 0
}

while getopts "w:c:s" OPTION
do
    case $OPTION in
        w)
            WARN_LIMIT="$OPTARG"
        ;;
        c)
            CRIT_LIMIT="$OPTARG"
        ;;
        s)
            USE_SUDO="1"
        ;;
    esac
done

warn_limit=${WARN_LIMIT:-90}
crit_limit=${CRIT_LIMIT:-97}

if [ ! -z "$USE_SUDO" ]
then
    cmd="sudo df"
else
    cmd="df"
fi

out=$($cmd -P -l -k -t ext2 -t ext3 -t ext4 -t xfs -t simfs -t overlay | grep -E "/$|/ephemeral")
for i in $(echo "$out" | awk '{print $NF};')
do
    used_space=$(echo "$out" | grep " $i\$" | awk '{print $5};' | sed 's/%//g')
    if [ "$used_space" -ge "$crit_limit" ]
    then
        crit_flag=1
        message="$message$used_space% used on $i. "
    elif [ "$used_space" -ge "$warn_limit" ]
    then
        warn_flag=1
        message="$message$used_space% used on $i. "
    fi
done

if [ $crit_flag -ne 0 ]; then die 2 "$message"; fi
if [ $warn_flag -ne 0 ]; then die 1 "$message"; fi
die 0 "OK"
