#!/bin/bash

exec 2>&1
set -ex

# Fix logrotate
sed -i "s~/usr/lib/rsyslog/rsyslog-rotate~workload_signal syslog SIGHUP~" /etc/logrotate.d/rsyslog

# Fix cron configs:
sed -i 's/^session.*pam_loginuid.so/#&/' /etc/pam.d/cron

# fix permissions
chmod -R a-x+X,og-w /etc/{cron,logrotate,rsyslog}.d/

# Create push-client dirs:
function push_client_dir() {
    mkdir -p $1
    chown -Rv statbox:statbox $1
    chmod 775 $1
}
PUSH_CLIENT_DIRS=(
    /etc/push-client
    /var/lib/push-client/
    /var/lib/push-client-state/
    /var/log/push-client/
)
for dir in ${PUSH_CLIENT_DIRS[*]}
do
    push_client_dir $dir
done

# Create dir for juggler checks
mkdir -p /juggler/checks/local/

# Create dir for nginx
mkdir -p /var/spool/nginx

# Create dir for geobase
mkdir -p /var/cache/geobase

# Fix lua for nginx:
ln -sf /usr/lib/x86_64-linux-gnu/lua/ /usr/local/lib/lua

# Create app dirs
mkdir -p /app/log
chown app:app /app/log

mkdir -p /app/secrets
chmod 755 /app/secrets

# Remove useless cron files from deb-packages:
dpkg -S /etc/cron.*/* 2>/dev/null | awk '{print "rm -rf "$2}' | bash

# Use a system certificate for python3
ln -sf /etc/ssl/certs/ca-certificates.crt /usr/local/lib/python3.8/dist-packages/certifi/cacert.pem
