#!/bin/bash

: ${DUFFMAN_BASEPORT:?Define DUFFMAN_BASEPORT}
: ${DUFFMAN_WORKERS:=1}

# Emulate Qloud TVM environment
export QLOUD_TVM_INTERFACE_ORIGIN=$DEPLOY_TVM_TOOL_URL
export QLOUD_TVM_TOKEN=$TVMTOOL_LOCAL_AUTHTOKEN
if [[ -v DEPLOY_TVM_CONFIG ]]; then
    export QLOUD_TVM_CONFIG=$DEPLOY_TVM_CONFIG
else
    export QLOUD_TVM_CONFIG=$(
        cat /pod_agent_public/human_readable_current_spec.json | \
        jq -r '.spec.resources.static_resources | .[] | select(.id == "tvm_conf_resource") | .files.files[0].raw_data' | \
        jq -c .
    )
fi

# TODO придумать как правильно
: ${DUFFMAN_CUSTOM_LOG_ARGS=qloud_path=$DEPLOY_STAGE_ID.$DEPLOY_UNIT_ID}
export DUFFMAN_CUSTOM_LOG_ARGS

export NODE_EXTRA_CA_CERTS=/usr/share/yandex-internal-root-ca/YandexInternalRootCA.crt

# Подождать запуска rsyslogd
until pidof -q rsyslogd; do
    sleep 1
done

cd /app/front
exec /app/duffman \
    -w $DUFFMAN_WORKERS \
    -g $DUFFMAN_WORKERS \
    -p $DUFFMAN_BASEPORT \
    --routes /app/duffman-routes \
    --fail-fast \
    -P 7099
