if [[ -n "$CHECK_EPHEMERAL" ]] && [[ ! -d /ephemeral ]]; then
    >&2 echo "Ephemeral not found"
    exit 1
fi

if [[ -n "$CHECK_NGINX_SSL" ]]; then
    if [[ ! -f /app/secrets/ssl_cert.pem ]]; then
        >&2 echo "No certificates found, cannot start"
        exit 1
    fi

    ln -svf /app/secrets/ssl_cert.pem /app/secrets/ssl_key.pem
fi

if [[ -n "$CHECK_GEODATA5" ]]; then
    if [[ -f /var/cache/geobase/geodata5.bin ]]; then
        echo "geodata5 ok"
    else
        >&2 echo "No geodata5 found, cannot start"
        exit 1
    fi
fi

if [[ -n "$CHECK_GEODATA6" ]]; then
    if [[ -f /var/cache/geobase/geodata6.bin ]]; then
        echo "geodata6 ok"
    else
        >&2 echo "No geodata6 found, cannot start"
        exit 1
    fi
fi
