if [[ -z $DUFFMAN_DISABLE ]]; then
    export DUFFMAN_CUSTOM_LOG_ARGS="qloud_path=$QLOUD_PROJECT.$QLOUD_APPLICATION.$QLOUD_ENVIRONMENT.$QLOUD_COMPONENT"

    if check_ephemeral; then
        qloud_log nginx
        qloud_log push-client statbox:statbox
        qloud_log supervisor

        qloud_link /app/log syslog:adm

        qloud_link /var/lib/push-client statbox:statbox
    fi

    mkdir -p /var/lib/push-client/front
    chown -R statbox:statbox /var/lib/push-client/front

    . /app/init/duffman.sh
    . /app/init/nginx-duffman.sh
    . /app/init/nginx.sh

    ln -s ../conf-available/{duffman,nginx,syslog}.conf /etc/supervisor/conf.d/

    sed -i "s~^###~~" /etc/cron.d/wd-duffman

    rm -f /var/run/rsyslogd.pid
fi
