#!/bin/bash

source /usr/lib/qloud-mail-common.sh
source /usr/lib/qloud-functions-mx.sh

# Создаем симлинк для запуска updater:
if [ -v UPDATER ] && [ $UPDATER -eq 1 ];then
    updater_link
fi

# Создаем симлинк для запуска yasmagent:
if [ -v YASM_AGENT ] && [ $YASM_AGENT -eq 1 ];then
    yasm_agent_link
fi

# Создаем симлинк для запуска updater и обновления мониторингов из ресурса:
if [ -v YAMAIL_MX_MONITOR ] && [ $YAMAIL_MX_MONITOR -eq 1 ];then
    yamail_mx_monitor_enable
fi

# Создаем симлинк для запуска yasmagent:
if [ -v UNISTAT_DAEMON ] && [ $UNISTAT_DAEMON -eq 1 ];then
    mkdir -p /tmp/unistat
    unistat_daemon_link
fi

# Принудительно выставляем "правильные" права для конфигов cron-а:
chmod 644 /etc/cron.d/*
chown root:root /etc/cron.d/*

# Принудительно выставляем "правильные" права для конфигов logrotate:
for dir in $(find /etc/logrotate.* -type d);do
    chmod -v 644 $dir/*;
    chown -v root:root $dir/*;
done
