#!/usr/bin/env python

import os
import socket

from SimpleHTTPServer import SimpleHTTPRequestHandler
from BaseHTTPServer import HTTPServer

PORT = 8081
PKG = "yamail-mx-monitor"


class IPv6HTTPServer(HTTPServer):
    address_family = socket.AF_INET6


class UpdateHandler(SimpleHTTPRequestHandler):

    def do_HEAD(self):
        raise NotImplementedError()

    def do_GET(self):
        raise NotImplementedError()

    def do_POST(self):
        if self.path != "/%s/update" % PKG:
            return
        # Assumed dependencies already exist in base image
        res = os.system(("pkg=$(ls /tmp/%s/%s*.deb | head -n 1) && "
            "dpkg-deb --extract ${pkg} / && "
            "dpkg-deb --control ${pkg} /tmp/%s && "
            "bash /tmp/%s/postinst") % (PKG, PKG, PKG, PKG))
        if res != 0:
            self.send_response(500)
        else:
            self.send_response(200)
        self.send_header("Content-type", "text/plain")
        self.end_headers()
        self.wfile.write("exit_code=%d" % res)


if __name__ == "__main__":
    httpd = IPv6HTTPServer(("::", PORT), UpdateHandler)
    print "serving at port", PORT
    httpd.serve_forever()
