#!/bin/bash

# remove stale syslog pid
if [[ -f /var/run/rsyslogd.pid ]]; then
    rm -f /var/run/rsyslogd.pid
    echo "removed stale syslog pid"
fi

source /opt/service.sh

# $app variable should be set via service.sh script
if [[ ! -z "${app}" ]]; then
    export app="${app}"
    envsubst < "/usr/bin/welcome" > "/usr/bin/welcome.new"
    mv "/usr/bin/welcome.new" "/usr/bin/welcome"
    chmod 755 "/usr/bin/welcome"

    if [[ -f "/usr/share/${app}/about" ]]; then
        echo "cat /usr/share/${app}/about" > /usr/bin/about
        chmod 755 /usr/bin/about
    fi
fi

/usr/bin/supervisord -c /etc/supervisor/supervisord.conf
