#!/usr/bin/python
# -*- coding: UTF-8 -*-
import argparse
import subprocess
import re
from yamail.qloud import environ
from yamail import monrun

DEFAULT_LIMITS = {"warning": 80, "critical": 90}


def main(LIMITS):

    cmd = "top -b -n1"
    p = subprocess.Popen(cmd.split(), stdout=subprocess.PIPE)
    result = p.communicate()[0].splitlines()
    mem_usage = 0
    mem_usage_max = float(environ["user_environment"]["QLOUD_MEMORY_LIMIT"]) / 1000

    pid_found = False
    for line in result:
        if pid_found:
            mem_usage += float(line.split()[5])
        if re.search("PID", line):
            pid_found = True

    current_mem_usage = mem_usage/mem_usage_max * 100

    status = monrun.OK
    if current_mem_usage > LIMITS.warning and current_mem_usage < LIMITS.critical:
        status = monrun.WARNING
    if current_mem_usage > LIMITS.critical:
        status = monrun.CRITICAL

    monrun.report(status, str(int(current_mem_usage)) + "%")


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description=("monitoring mem usage"))
    parser.add_argument("-w", "--warning", type=int,
                        default=DEFAULT_LIMITS["warning"], help="Warning limit (in %%)")
    parser.add_argument("-c", "--critical", type=int,
                        default=DEFAULT_LIMITS["critical"], help="Critical limit (in %%)")


    LIMITS = parser.parse_args()
    main(LIMITS)
