#!/bin/bash

source "/etc/yamail/yamail-logbackup.conf"

BACKUP_LOG="/var/log/yamail-logbackup.log"
TIMESTAMP=$(date --date=yesterday +%Y%m%d)

RSYNC_USER="yamail"
RSYNC_PWDFILE="/etc/yamail/.yamail-logbackup-rsync.passwd"
RSYNC_AREA="backup"

HOSTNAME=$(hostname -s)

echo $(date) >> "${BACKUP_LOG}"

APPLICATION=$(cat /etc/qloud/meta.json | python3 -c "import sys, json; print(json.load(sys.stdin)['user_environment']['QLOUD_APPLICATION'].lower())")
ENVIRONMENT=$(cat /etc/qloud/meta.json | python3 -c "import sys, json; print(json.load(sys.stdin)['user_environment']['QLOUD_ENVIRONMENT'].lower())")
COMPONENT=$(cat /etc/qloud/meta.json | python3 -c "import sys, json; print(json.load(sys.stdin)['user_environment']['QLOUD_COMPONENT'].lower())")

if [[ "x${APPLICATION}" == "x" ]] || [[ "x${ENVIRONMENT}" == "x" ]] || [[ "x${COMPONENT}" == "x" ]]; then
    echo "[ERROR] Missing data from meta.json" >> "${BACKUP_LOG}"
    exit 1
fi

HOSTTYPE="${APPLICATION}_${ENVIRONMENT}_${COMPONENT}"

DC=$(cat /etc/qloud/meta.json | python3 -c "import sys, json; print(json.load(sys.stdin)['datacenter'].lower())")

if [[ "x${DC}" == "x" ]]; then
    echo "[ERROR] Missing data from meta.json" >> "${BACKUP_LOG}"
    exit 1
fi

LOGSTOREHOST="logstore-${DC}.mail.yandex.net"

echo "Starting upload" >> "${BACKUP_LOG}"
sleep $((RANDOM%3600+90))

for log in ${logs[@]} ; do
    if [[ -f "${log}.0.gz" ]]; then
        LOG_SHORT=$(echo "${log}" | sed 's/\/var\/log\///g' | sed 's/\//_/g')
        rsync -av --log-file="${BACKUP_LOG}" --password-file="${RSYNC_PWDFILE}" "${log}.0.gz" rsync://${RSYNC_USER}@${LOGSTOREHOST}/${RSYNC_AREA}/${HOSTTYPE}/${HOSTNAME}/"${LOG_SHORT}.${TIMESTAMP}.gz" >> "${BACKUP_LOG}" 2>&1
        
        if [[ "$?" != 0 ]]; then
            echo "[ERROR] Failed to upload ${log}.0.gz" >> "${BACKUP_LOG}"
        fi
    else
        echo "[WARN] File ${log}.0.gz does not exist" >> "${BACKUP_LOG}"
    fi
done

echo -e "All done\n" >> "${BACKUP_LOG}"
