from setuptools import setup, find_packages


def debian_version():
    import re

    data = open("debian/changelog").read(65535)
    version = re.search(r"^[^ ]+ \(([^)]+)\) .*urgency=", data).group(1)
    return version


VERSION = debian_version()


setup_kwargs = dict(
    name="tskv_logging",
    version=VERSION,
    description="Common library for logging from python to stat / yt in tskv",
    packages=find_packages(),
    install_requires=("data_logging>=1.0",),
    author="Anton Vasilev",
    author_email="hhell@yandex-team.ru",
    url="https://github.yandex-team.ru/statbox/python-tskv-logging",
)


if __name__ == "__main__":
    setup(**setup_kwargs)
