"""
Annotating filters

https://docs.python.org/2/howto/logging-cookbook.html#adding-contextual-information-to-your-logging-output
"""

from data_logging.annotators import (
    Annotator,
    make_simple_annotating_filter,
    time_diff_annotator,
    short_hostname_annotator,
    full_hostname_annotator,
    celery_task_name_annotator,
    celery_task_id_annotator,
    celery_process_name_annotator,
    extra_defaults_annotator,
    cached_getfqdn,
    get_celery_task_attributes,
)

__all__ = (
    "time_diff_annotator",
    "short_hostname_annotator",
    "full_hostname_annotator",
)
