# coding; utf8

"""
Additional assorted helpers.
"""

import os
import posixpath
import functools
from data_logging.utils import (
    simple_cached_wrap,
    split_list,
    slstrip,
    srstrip,
    DEFAULT_LOGGER_CONFIG,
    make_file_logger_file,
    make_file_logger_syslog,
    make_file_logger_null,
    to_bytes,
    to_text,
    to_str,
    force_bytes,
)
from data_logging.subsix import text, PY_3


__all__ = (
    "simple_cached_wrap",
    "tskv_encode",
)


# compat
default_logger_config = DEFAULT_LOGGER_CONFIG


def tskv_escape(val, default=force_bytes):
    if isinstance(val, int):  # NOTE: this also includes booleans.
        val = text(val)
    elif isinstance(val, float):
        val = "%.6f" % (val,)
    elif val is None:
        val = ""

    if isinstance(val, text):
        val = val.encode("utf-8", errors="replace")

    if not isinstance(val, bytes):
        val = default(val)
        if not isinstance(val, bytes):
            raise Exception("tskv_escape's `default` did not return `bytes`")

    return (
        val.replace(b"\\", br"\\")
        .replace(b"\t", br"\t")
        .replace(b"\n", br"\n")
        .replace(b"\r", br"\r")
        .replace(b"\0", br"\0")
        # Only needed in keys, but applied everywhere.
        .replace(b"=", br"\=")
    )


def tskv_encode(items, header=True, sep=b"\t", default=str):
    """
    ...

    See also:
    https://clickhouse.yandex/docs/en/interfaces/formats/#tskv
    https://github.com/daskol/tskv
    """
    res = sep.join(
        b"%s=%s" % (tskv_escape(key, default=default), tskv_escape(val, default=default))
        for key, val in items
    )
    if header:
        res = b"tskv%s%s" % (sep, res)
    return res
