from libc.stdint cimport uint32_t, uint64_t
from libc.time cimport time_t
from cython.operator cimport dereference


cdef extern from "ticket_parser2_inc.h":
    cdef enum ETicketParser2ErrorCode:
        TP2EC_OK = 0,
        TP2EC_DEPRECATED,
        TP2EC_EMPTY_TVM_KEYS,
        TP2EC_EXPIRED_TICKET,
        TP2EC_INVALID_BLACKBOX_ENV,
        TP2EC_INVALID_DST,
        TP2EC_INVALID_PARAM,
        TP2EC_INVALID_TICKET_TYPE,
        TP2EC_MALFORMED_TICKET,
        TP2EC_MALFORMED_TVM_KEYS,
        TP2EC_MALFORMED_TVM_SECRET,
        TP2EC_MISSING_KEY,
        TP2EC_NOT_ALLOWED,
        TP2EC_SIGN_BROKEN,
        TP2EC_SMALL_BUFFER,
        TP2EC_UNEXPECTED_ERROR,
        TP2EC_UNSUPPORTED_VERSION,
    cdef struct TTP2_ServiceContext
    cdef struct TTP2_ServiceTicket
    cdef struct TTP2_UserContext
    cdef struct TTP2_UserTicket


cdef extern from "ticket_parser2_inc.h":
    cdef enum TP2_EBlackboxEnv:
        EBE_PROD = 0,
        EBE_TEST,
        EBE_PROD_YATEAM,
        EBE_TEST_YATEAM,
        EBE_STRESS


cdef extern from "ticket_parser2_inc.h":
    cdef const char* TP2_ErrorCodeToString(ETicketParser2ErrorCode code)


cdef extern from "ticket_parser2_inc.h":
    cdef ETicketParser2ErrorCode TP2_CreateServiceContext(
        uint32_t clientId,
        const char* secretBase64,
        size_t secretBase64Size,
        const char* tvmKeysResponse,
        size_t tvmKeysResponseSize,
        TTP2_ServiceContext** context)

    cdef ETicketParser2ErrorCode TP2_DeleteServiceContext(TTP2_ServiceContext* context)

    cdef ETicketParser2ErrorCode TP2_CheckServiceTicket(
        const TTP2_ServiceContext* context,
        const char* ticketBody,
        size_t ticketBodySize,
        TTP2_ServiceTicket** ticket)

    cdef ETicketParser2ErrorCode TP2_DeleteServiceTicket(TTP2_ServiceTicket* ticket)

    cdef ETicketParser2ErrorCode TP2_GetServiceTicketSrc(
        const TTP2_ServiceTicket* ticket,
        uint32_t* srcClientId)

    cdef ETicketParser2ErrorCode TP2_GetServiceTicketScopesCount(
        const TTP2_ServiceTicket* ticket,
        size_t* count)

    cdef ETicketParser2ErrorCode TP2_GetServiceTicketScope(
        const TTP2_ServiceTicket* ticket,
        size_t idx,
        const char** scope)

    cdef ETicketParser2ErrorCode TP2_HasServiceTicketScope(
        const TTP2_ServiceTicket* ticket,
        const char* scope,
        size_t scopeSize,
        int* checkingResult)

    cdef ETicketParser2ErrorCode TP2_GetServiceTicketDebugInfo(
        const TTP2_ServiceTicket* ticket,
        char* debugInfo,
        size_t* debugInfoSize,
        size_t maxDebugInfoSize)

    cdef ETicketParser2ErrorCode TP2_RemoveServiceTicketSignature(
        const char* ticketBody,
        size_t ticketBodySize,
        const char** logableTicket,
        size_t* logableTicketSize)

    cdef ETicketParser2ErrorCode TP2_ResetServiceContextKeys(
        TTP2_ServiceContext* context,
        const char* tvmKeysResponse,
        size_t tvmKeysResponseSize)

    cdef ETicketParser2ErrorCode TP2_SignCgiParamsForTvm(
        const TTP2_ServiceContext* context,
        const char* ts,
        size_t tsSize,
        const char* dst,
        size_t dstSize,
        const char* scopes,
        size_t scopesSize,
        char* signature,
        size_t* signatureSize,
        size_t maxSignatureSize)


cdef extern from "ticket_parser2_inc.h":
    cdef ETicketParser2ErrorCode TP2_CreateUserContext(
        TP2_EBlackboxEnv env,
        const char* tvmKeysResponse,
        size_t tvmKeysResponseSize,
        TTP2_UserContext** context)

    cdef ETicketParser2ErrorCode TP2_DeleteUserContext(TTP2_UserContext* context)

    cdef ETicketParser2ErrorCode TP2_CheckUserTicket(
        const TTP2_UserContext* context,
        const char* ticketBody,
        size_t ticketBodySize,
        TTP2_UserTicket** ticket)

    cdef ETicketParser2ErrorCode TP2_DeleteUserTicket(TTP2_UserTicket* context)

    cdef ETicketParser2ErrorCode TP2_GetUserTicketUidsCount(
        const TTP2_UserTicket* ticket,
        size_t* count)

    cdef ETicketParser2ErrorCode TP2_GetUserTicketUid(
        const TTP2_UserTicket* ticket,
        size_t idx,
        uint64_t* uid)

    cdef ETicketParser2ErrorCode TP2_GetUserTicketDefaultUid(
        const TTP2_UserTicket* ticket,
        uint64_t* uid)

    cdef ETicketParser2ErrorCode TP2_GetUserTicketScopesCount(
        const TTP2_UserTicket* ticket,
        size_t* count)

    cdef ETicketParser2ErrorCode TP2_GetUserTicketScope(
        const TTP2_UserTicket* ticket,
        size_t idx,
        const char** scope)

    cdef ETicketParser2ErrorCode TP2_HasUserTicketScope(
        const TTP2_UserTicket* ticket,
        const char* scope,
        size_t scopeSize,
        int* checkingResult)

    cdef ETicketParser2ErrorCode TP2_GetUserTicketDebugInfo(
        const TTP2_UserTicket* ticket,
        char* debugInfo,
        size_t* debugInfoSize,
        size_t maxDebugInfoSize)

    cdef ETicketParser2ErrorCode TP2_RemoveUserTicketSignature(
        const char* ticketBody,
        size_t ticketBodySize,
        const char** logableTicket,
        size_t* logableTicketSize)

    cdef ETicketParser2ErrorCode TP2_ResetUserContextKeys(
        TTP2_UserContext* context,
        const char* tvmKeysResponse,
        size_t tvmKeysResponseSize)

cdef extern from "ticket_parser2_inc.h":
    cdef const char* TP2_LibVersion()
