#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

# TODO merge functions
function ephemeral_log {
    rm -rf "/var/log/$1"
    mkdir -p "/ephemeral/logs/$1"
    ln -s "/ephemeral/logs/$1" /var/log/
}
function ephemeral_var {
    rm -rf "/var/$1"
    mkdir -p "/ephemeral/$1"
    ln -s "/ephemeral/$1" /var/
}

ENV_TYPE=$([ -z "$YENV_TYPE" ] && echo testing || echo "$YENV_TYPE")
if [[ -n "$APPLICATION" ]]; then
    app=$APPLICATION
else
    app=$QLOUD_APPLICATION
fi
environment=$ENV_TYPE
component=$QLOUD_COMPONENT

[[ $app && $environment && $ENV_TYPE ]] \
    || { echo "check env variables" > /errlog ; exit 1; }

chmod 775 /ephemeral
ephemeral_log $app
mkdir -p /tmp/$app/ || true
ls /var/$app/* &>/dev/null && rm -rf /tmp/$app/* && mv /var/$app/* /tmp/$app/
ephemeral_var $app
ls /tmp/$app/* &>/dev/null && mv /tmp/$app/* /var/$app/

for file in $(find /etc/statbox-push-client/*.yaml-${environment} 2>/dev/null); do
    ln -sf ${file} $(echo ${file} | sed "s/-${environment}$//")
done

[[ $PUSH_CLIENT_IDENT ]] \
    && sed -i "s/PUSH_CLIENT_IDENT/$PUSH_CLIENT_IDENT/" /etc/statbox-push-client/*.yaml

[[ $(find /etc/statbox-push-client/ -name '*.yaml') && -f /etc/$app/tvm_secret ]] \
    && sed -i "s/PUSH_CLIENT_TVM_SECRET/$(cat /etc/$app/tvm_secret)/" /etc/statbox-push-client/*.yaml

NGINX_RATELIMIT_BY_REMOTE_ADDR=${NGINX_RATELIMIT_BY_REMOTE_ADDR:-'20'}

for key in app QLOUD_APPLICATION QLOUD_ENVIRONMENT QLOUD_COMPONENT QLOUD_DATACENTER QLOUD_EXEC_USER NGINX_RATELIMIT_BY_REMOTE_ADDR; do
    value="${!key}"
    for file in $(fgrep -r -l "%$key%" /etc); do
        sed -i 's/#*%'"$key"'%/'"$value"'/g' "$file"
    done
done

mkdir -p /var/log/$app/
chown -R www-data:www-data /var/log/$app/
chown -R www-data:www-data /var/www/
chmod 0777 /var/log/$app/
chmod 0666 /var/log/$app/* || true

cp -f /var/www/.pgpass /root/ && chown root:root /root/.pgpass || true
cp -f /var/www/.pgpass /home/monitor/ && chown monitor:monitor /home/monitor/.pgpass

/usr/bin/env|grep -e "^QLOUD_" -e "^YENV_" |sed -e 's/^/export /' > /.env
echo $environment > /etc/yandex/environment.type
echo $environment > /etc/yandex/environment.name

echo "RUN $@"
exec "$@"