CREATE DATABASE IF NOT EXISTS fanstat;

-- Подготовка для реальных БД:
-- CREATE DATABASE IF NOT EXISTS fanstat;
-- CREATE USER fanuser IDENTIFIED WITH sha256_password BY '<password>';
-- GRANT SELECT,INSERT ON fanstat.* TO fanuser;

CREATE TABLE IF NOT EXISTS fanstat.feedback_events
(
    date     Date,
    event    String,
    account  UInt64,
    campaign UInt64,
    recipient String,
    user_agent String,
    user_ip String
) ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/feedback_events', '{replica}', date, (date, account, campaign), 8192);

-- ниже не используемые в новом рассыляторе

CREATE TABLE IF NOT EXISTS fanstat.counter_v2
(
    date     Date,
    email    String,
    campaign UInt64,
    account  UInt64,
    sign     Int8
) ENGINE = MergeTree(date, (date, email, campaign, account), 8192);

CREATE TABLE IF NOT EXISTS fanstat.delivery_activity
(
    date        Date,
    channel     String,
    recepient   String,
    event_date  DateTime,
    account     String,
    campaign    UInt64,
    letter      UInt64,
    letter_code String,
    message_id  String,
    status      UInt64,
    test_letter UInt8
) ENGINE = MergeTree(date, (channel, event_date, campaign, recepient, letter), 8192);

CREATE TABLE IF NOT EXISTS fanstat.click_activity
(
    date        Date,
    channel     String,
    event       String,
    event_type  String,
    recepient   String,
    event_date  DateTime,
    campaign    UInt64,
    account     String,
    letter      UInt64,
    link_id     String,
    link_url    String,
    test_letter UInt8,
    message_id  String
) ENGINE = MergeTree(date, (channel, event_date, campaign, recepient, letter, link_id), 8192);

CREATE TABLE IF NOT EXISTS fanstat.events_part
(
    date            Date,
    insert_date     DateTime,
    channel         String,
    event_key       String,
    event_date      DateTime,
    event           String,
    event_type      String,
    account_id      Int64,
    campaign_id     Int64,
    letter_id       Int64,
    message_id      String,
    theme_id        Int64,
    contact_id      Int64,
    contact_keyless UInt8,
    contact_key     String,
    link_id         String,
    email           String,
    status          String,
    error_detail    String,
    result          String,
    link            String,
    domain          String,
    user_ip         String,
    user_agent      String,
    request_scheme  String,
    request_host    String,
    context         String
) ENGINE = MergeTree(date, event_key, 8192);


CREATE TABLE IF NOT EXISTS fanstat.counter_part
(
    email    String,
    date     Date,
    campaign UInt64,
    account  UInt64,
    sign     Int8
) ENGINE = MergeTree(date, (date, email, campaign), 8192);
