#!/usr/bin/env bash

echo "host replication all all md5" >> "$PGDATA/pg_hba.conf"
cat >> "${PGDATA}/postgresql.conf" <<EOF
wal_level = hot_standby
wal_log_hints = on
max_wal_senders = 8
wal_keep_segments = 64
EOF

set -e

psql -v ON_ERROR_STOP=1 --username "$POSTGRES_USER" --dbname "$POSTGRES_DB" <<EOSQL
CREATE USER $PG_REP_USER REPLICATION LOGIN CONNECTION LIMIT 100 ENCRYPTED PASSWORD '$PG_REP_PASSWORD';
EOSQL
