#!/usr/bin/env bash

if [[ ! -s "$PGDATA/PG_VERSION" ]]; then

until ping -c 1 -W 1 pg_master; do
    echo "Waiting for postgres master to ping..."
    sleep 1s
done

echo "pg_master:${PG_MASTER_PORT}:replication:$PG_REP_USER:$PG_REP_PASSWORD" >> /root/.pgpass
chmod 0600 ~/.pgpass
until pg_basebackup -h pg_master --port=${PG_MASTER_PORT} -D ${PGDATA} -U ${PG_REP_USER} -vP -W --wal-method=stream; do
    echo "Waiting for master to connect... [${PG_REP_USER}@pg_master:${PG_MASTER_PORT}]"
    sleep 1s
done

set -e

cat >> ${PGDATA}/recovery.conf <<EOF
standby_mode = on
primary_conninfo = 'user=${PG_REP_USER} password=${PG_REP_PASSWORD} host=pg_master port=${PG_MASTER_PORT} sslmode=prefer sslcompression=0 krbsrvname=postgres target_session_attrs=any'
trigger_file = '/tmp/touch_me_to_promote_to_me_master'
EOF

chown -R postgres "$PGDATA"
chmod 700 "$PGDATA"

sed -i 's/wal_level = hot_standby/wal_level = replica/g' ${PGDATA}/postgresql.conf

echo "Done setting up slave"
fi

exec gosu postgres "$@"
