# Ответы API при возникновении ошибок

Данная информация относится к запросам API /api/0/...

## Общая структура ответа

В случае возниконовения любой ошибки в ходе обработки вызова API
ответ будет иметь HTTP код 4XX или 5XX и в содержимом будет json
следующего вида:

```
    {
        "result":{
            "status": "ERROR",
            "error": <детализация ошибки>
        }
    }
```

### Внутренние ошибки сервера

При возникновении внутренней ошибки сервера возвращается следущий ответ

```
    HTTP/1.1 500 Internal Server Error
    Content-Type: application/json

    {
        "result": {
            "status": "ERROR",
            "error": "Internal error"
        }
    }
```

### Ошибки авторизации

В случае ошибки авторизации или неавторизованного доступа к API возвращаемый ответ будет содержать поле result.error.detail с причиной ошибки. Например:

```
    HTTP/1.0 401 UNAUTHORIZED
    Content-Type: application/json

    {
        "result": {
            "status": "ERROR",
            "error": {
                "detail": "API key is not valid"
            }
        }
    }
```

### Неправильное указание объектов

В случае, если объект рассылятора указан в запросе некорректно ответ будет содержать поле result.error.detail с причиной ошибки.
Например:

```
    HTTP/1.0 404 NOT FOUND
    Content-Type: application/json

    {
        "result": {
            "status": "ERROR",
            "error": {
                "detail": "Account not found"
            }
        }
    }
```

### Ошибки в передаваемых параметрах

Если при вызове метода были переданы некорректные параметры, то в поле error будет объект с указанием поля и ошибок, возникших при его проверке.
Список возможных ошибок для полей:

| Ошибка                 | Причина                                                      |
|------------------------|--------------------------------------------------------------|
| Field required         | Обязательный параметр не передан                             |
| Need value             | Передано пустое значение для обязательного параметра         |
| Invalid value          | Некорректное значение параметра                              |
| Too long               | Значение параметра имеет слишком большую длину               |
| Too short              | Значение параметра имеет слишком маленькую длину             |
| Bad number             | Значение параметра не является корректным числом             |
| Need datetime          | Параметр должен содержать дату и время                       |
| Need date without time | Параметр должен содержать только дату                        |
| Not valid choice       | Значение не соответвует допустимым вариантам для параметра   |
| Need items list        | Требуется список значений                                    |
| Need file name         | В параметре должно содержаться имя файла                     |

Например:

```
    HTTP/1.0 400 BAD REQUEST
    Content-Type: application/json

    {
        "result": {
            "status": "ERROR",
            "error": {
                "html":["Field required"],
                "subject":["Field required"]
            }
        }
    }
```

### Прочие ошибки

В методах API могут возникать другие логические ошибки, специфичные для данного метода. В этом случае в стуктуре ответа должно содержаться поле result.error.detail с причиной возникновения ошибки.
