# Описание публичного API

Публичный API предназначен для приема событий от внешних систем для последующей обраотки.

## Авторизация

Запросы к API нужно делать с ключами, которые создаются для аккаунта.
Ключ нужно передавать в HTTP Basic auth в качестве имени пользователя, пароль при этом пустой.


## Отправка события

Параметры события передаются JSON'ом в теле запроса.

    POST /events/api/0/events
    
Пример вызова:

    curl -X POST \
        -u a21fa747d42b47e0a825e36a38305a78: \
        -H 'Content-Type: application/json' \
        -d \
        '
            {
                "args": {"campaign_id": 2604, "letter_code": "A", "link_number": 1, "email": "test@yandex.ru"},
                "event_type": "sender.letter_link_click"
            }
        ' \
        'https://test.sender.yandex-team.ru/events/api/0/events'

Параметры:

 * event-type – тип произошедшего события
 * args – аргументы события, обязательно должен содержать email, для корректной обработки действия на отправку письма
 
Пример ответа:

    HTTP/1.1 200 OK
    Content-Type: application/json

    {
        "response": {
            "accepted": true
        },
        "status": "ok"
    }

### Типы событий
Типы событий идентифицируются их кодом.

Код должен иметь формат `<system>[.<component>].<event_code>`, где:
- `<system>` - система, в которой происходит событие
- `<component>` - опциональное поле, если похожие по смыслу события могут регистрировать разные компоненты системы и их необходимо различать
- `<event_code>` - код события

Все части кода типа события должны отвечать следующим правилам:
- допустимо использовать только следующие символы: буквы нижнего регистра ("маленькие") латинского алфавита, цифры, знак подчеркивания
- каждая часть должна начинаться с буквы

Например:
```
sender.delivery.mail_sent
```


