# Шаблонизация

В качестве шаблонизатора используется jinja2.
Документация [здесь](http://jinja.pocoo.org/docs/2.9/templates/)

Но существуют отличия от документации, связанные с особенностями среды.

## Примеры шаблонов

    Здравствуйте{% if name %}, уважаемый {{ name }} {% endif %}!
    

## Что не будет работать

* Наследование шаблонов
* Стандартные операторы сравнения (>, <, >=, <=). Для их замены реализованы кастомные [тесты](#Кастомные-тесты)

## Кастомные тесты

Тесты – специальная конструкция шаблонизатора, которая используется для проверки значений переменных в условиях, взамен обычным выражениям.

Пример: 
    
    {% if foo.expression is equalto 42 %}
        the foo attribute evaluates to the constant 42
    {% endif %}

Подробнее в [документации](http://jinja.pocoo.org/docs/2.9/templates/#tests).
В рассыляторе помимо [стандартных](http://jinja.pocoo.org/docs/2.9/templates/#builtin-tests) поддерживаются ряд дополнительных тестов.

### gt

Замена условного оператора `>` 

Пример: 
    
    {% if a is gt b %}
        a больше b
    {% endif %}

### lt

Замена условного оператора `<` 

Пример: 
    
    {% if a is lt b %}
        a меньше b
    {% endif %}

### gte

Замена условного оператора `>=` 

Пример: 
    
    {% if a is gte b %}
        a больше, либо равен b
    {% endif %}


### lte

Замена условного оператора `<=` 

Пример: 
    
    {% if a is lte b %}
        a меньше, либо равен b
    {% endif %}

### eq

Замена условного оператора `==` 

Пример: 
    
    {% if a is eq b %}
        a равно b
    {% endif %}
    
### ne

Замена условного оператора `!=` 

Пример: 
    
    {% if a is ne b %}
        a не равно b
    {% endif %}

## Кстомные фильтры

Фильтры используются для модификации переменных.

Пример:
    
    {{ name|upper }}
    
    {% set abs_a = a|abs %}
    {% if abs_a greater_or_equals_than 10 %}
        {{ abs_a }}
    {% endif %}


Подробнее в [документации](http://jinja.pocoo.org/docs/2.9/templates/#filters).
В рассыляторе помимо [стандартных](http://jinja.pocoo.org/docs/2.9/templates/#builtin-filters) поддерживаются ряд дополнительных фильтров.

### required

Этот фильтр не даст отправить письмо, если переменная, к которой он применяется не передана в шаблон. Без этого фильтра будет подставлена пустая строка.
Помогает избежать ошибок, которые возникают при формировании списков рассылки.

Пример:

    Ваш промокод: {{ promo|required }}

### json_decode

Позволяет парсить строки в формате json.

Пример:

    {% set json_data = data|json_decode %}
    
    {% for item in json_data %}
        {{ item.name }}
        {{ item.price }}
    {% endfor %} 
 
 