# Отписка

## Введение

Рассылятор генерирует уникальную ссылку для отписки для каждого письма.


Чтобы вставить ссылку в тело письма, используйте встроенную переменную `unsubscribe_link`, например:
```html
    <a href="{{ unsubscribe_link }}">Отключить рассылку</a>
```

Ссылка отписки автоматически добавяется в хэдер List-Unsubscribe, даже если в теле письма ссылки нет.

В продакшене ссылка выглядит примерно так: ```https://click.sender.yandex.ru/unsubscribe/XXXX```

Ссылка включает в себя секретную часть с зашифрованным адресом пользователя и номером рассылки.

Когда пользователь переходит по ссылке, Рассылятор расшифровывает секретную часть и делает следующие действия:
 * отписывает email в каждом постоянном списке, который использовался в рассылке
 * если у рассылки прописан "event-hook" с признаком "on unsubscribe", то ставит в очередь задачу на вызов этого хука
 * если у рассылки указан кастомный редирект, то отдаёт браузеру этот редирект. Если кастомный редирект не указан, то отправляет на дефолтный url ```mail.yandex.ru/unsubscribe.html```

## Глобальная отписка для аккаунта

В аккаунте автоматически создается список отписки "Глобальный", который используется в случае применения отписок в рассылке.
Добавление в список возможно с использованием встроенной переменной `global_unsubscribe_link`, например:
```html
    <a href="{{ global_unsubscribe_link }}">Не получать больше от нас рассылок</a>
```

При использовании глобальной отписки email добавляется только в глобальный список.


## Интеграция процесса отписки

Известны три способа интерграции процесса отписки с бэкэндом любого сервиса.

### Интеграция бэкенда и Рассылятора

Сервис делает на своей стороне лендинг и http-ручку для веб-хука.
В шаблоне письма указывается ссылка на отписку Рассылятора.
Рассылятор расшифровывает ссылку, передаёт информацию в http-ручку бэкенда и отправляет пользователя на лендинг сервиса.

### Без интеграции

Внутренние механизмы отписки Рассылятора не используются.
Сервис добавляет в список рассылки секретное поле (название может быть любым, для примера назовём его ```secret_code```)
и добавляет в тело письма ссылку на свой лендинг, которая включает в себя это поле,
например ```<a href="http://kinopoisk.ru/unsibscribe?secret={{ secret_code }}">Отказаться от рассылки</a>```
Пользователь попадает напряму на страницу сервиса, где сервис сам расшифровывает секрет и делает всю магию отписки.


### Офлайн-интеграция

Если сервису не нужно получать информацию об отписке в режиме реального времени,
то он может ходить в [API Рассылятора](unsubscribe-api.md "API для управления списком отписки") в офлайне, чтобы забирать список отписантов.

