import logging

from base64 import b64decode
from django.http.response import HttpResponse
from fan.links.unsubscribe import decode_unsubscribe_code2
from fan.utils.request_data import get_user_agent, get_user_ip
from fan_feedback.typed_log import log_pixel


PX = b64decode(
    "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mP4Xw8AAoABf5/NhYYAAAAASUVORK5CYII="
)


def px(request, path):
    """
    Обрабатываем счетчик открытий письма (пиксель).
    Всегда отдаём прозрачный пиксель.
    """
    try:
        email, campaign_id, letter_id, message_id, for_testing = _parse_secret_code(path)
        log_pixel(
            email,
            campaign_id,
            letter_id,
            message_id,
            for_testing,
            get_user_agent(request),
            get_user_ip(request),
        )
    except Exception:
        logging.exception("pixel processing error")

    return HttpResponse(content=PX, content_type="image/png")


def _parse_secret_code(path):
    try:
        parts = path.strip("/").split("/", 2)  # ['10', 'A', 'L/XXXX/']
        if len(parts) == 3:
            return decode_unsubscribe_code2(parts[2])
    except (TypeError, ValueError):
        return (None,) * 5
