from django.http.response import HttpResponseRedirect
from django.conf import settings

from fan.links.unsubscribe import DecodeError, decode_unsubscribe_code2
from fan.utils.request_data import RequestData
from fan.feedback.unsubscribe.action import make_campaign_unsubscribe, make_general_unsubscribe
from fan_feedback.typed_log import log_email_unsubscribe


def unsubscribe(request, path):
    try:
        email, campaign_id, letter_id, message_id, for_testing = _decode_url_path(path)
    except DecodeError:
        return _redirect()

    # TODO refactor
    unsub_type = request.GET.get("type", "")
    is_general = unsub_type.lower() == "global"

    log_email_unsubscribe(email, campaign_id, letter_id, message_id, for_testing)

    if for_testing or email is None or campaign_id is None:
        return _redirect()

    reason = "unsubscribe link"
    if is_general:
        make_general_unsubscribe(campaign_id, email)
        reason = "account unsubscribe link"
    make_campaign_unsubscribe(
        campaign_id, email, letter_id, reason=reason, request_data=RequestData.from_request(request)
    )

    return _redirect()


def _decode_url_path(path):
    try:
        return decode_unsubscribe_code2(path)
    except (TypeError, ValueError):
        return (None,) * 5


def _redirect():
    return HttpResponseRedirect(settings.DEFAULT_UNSUBSCRIBE_LANDING_URL)
