#!/usr/bin/env python3

import os
import sys

# Virtualenv staff
try:
    # Add relative path
    this_path = os.path.dirname(os.path.realpath(__file__))
    sys.path.insert(0, os.path.dirname(this_path))

    # Seek for virtualenv
    activate_this = os.path.join(os.path.dirname(os.path.realpath(__file__)), "activate_this.py")
    if os.path.isfile(activate_this):
        exec(
            compile(open(activate_this).read(), activate_this, "exec"), dict(__file__=activate_this)
        )
    del activate_this

    # Adding related to package path
    import fan_feedback

    ext_dirname = os.path.dirname(fan_feedback.__file__)
    root_dirname = os.path.dirname(ext_dirname)
    sys.path.insert(0, ext_dirname)
    sys.path.insert(0, root_dirname)
except (IOError, ImportError) as exc:
    pass

if __name__ == "__main__":
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "settings")

    from django.core.management import execute_from_command_line

    execute_from_command_line(sys.argv)
