class TSKV:
    def to_dict(self, string):
        """
        Turns valid .tskv string into dict.
        Valid .tskv string looks like:
            'tskv      key=value       key1=value1'
        """
        d = dict()

        if isinstance(string, bytes):
            string = string.decode("utf-8")

        if string.startswith("tskv"):
            # chop off leading 'tskv' substring
            for field in string.split("\t")[1:]:
                if "=" in field:
                    k, v = field.split("=", 1)
                    d[k] = v
                else:
                    # Emtpy field -- probably a runaway tab. Skip it.
                    continue
        else:
            raise ValueError("given string is not in TSKV format")
        return d
