import itertools
from stats.logbrocker_workaround import TSKV


def get_log_lines_since(filename, datetime_since=None):
    return itertools.chain(_filter_file_lines(filename, datetime_since))


def _filter_file_lines(f_path, datetime_since):
    with open(f_path, mode="r") as f:
        for line in f:
            timestamp = _extract_timestamp(line)
            if not timestamp:
                continue
            if datetime_since and timestamp < datetime_since:
                continue
            yield line


def _extract_timestamp(line):
    """Given TSKV formatted line check it's timestamp field."""
    line = line.strip()
    tskv_converter = TSKV()
    try:
        data = tskv_converter.to_dict(line)
    except ValueError:
        return None

    timestamp = data.get("timestamp")
    if not timestamp:
        return None

    return timestamp.strip()
