import logging
from datetime import date, datetime

from django.core.management.base import BaseCommand
from fan.utils.logging_ import duplicate_log_to_stream

from fan.utils.logging_ import log_function_call
from ._statbag import StatbagLoader


class Command(BaseCommand):
    help = "Load all statistics"

    def add_arguments(self, parser):
        parser.add_argument("--date", dest="date_str", default="")

    @log_function_call(name="load_stats")
    def handle(self, *args, **options):
        with duplicate_log_to_stream():
            date_str = options["date_str"]
            if date_str:
                calc_date = datetime.strptime(date_str, "%Y-%m-%d").date()
            else:
                calc_date = date.today()

            logging.info("loading stats for date %s", calc_date)
            try:
                StatbagLoader().update_stats(calc_date)
            except Exception:
                logging.exception("failed to update stats for date %s", calc_date)
                raise
