"""
WSGI config for fan project.

It exposes the WSGI callable as a module-level variable named ``application``.

For more information on this file, see
https://docs.djangoproject.com/en/1.7/howto/deployment/wsgi/
"""

import os

try:
    # uwsgi environment
    import sys
    import fan_feedback

    sys.path.insert(0, os.path.dirname(fan_feedback.__file__))
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "fan_feedback.settings")
except ImportError:
    # runserver
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "settings")

from django.core.wsgi import get_wsgi_application

application = get_wsgi_application()

import fan.app

assert fan.app.check_configuration()
