#!/usr/bin/env python3

import argparse
import asyncio
import datetime
from aiosmtpd.controller import Controller


LISTEN_ADDR = "::"
RESPONSE_DELAY = 0.4
DEFAULT_RESPONSE = "250 OK"


def timestamp():
    d = datetime.datetime.now()
    return d.strftime("%Y-%m-%d %H:%M:%S.%f")


def log(**kwargs):
    line = "tskv\ttskv_format=mail-fan-smtp-server-log\ttimestamp=%s" % timestamp()
    for key, value in kwargs.items():
        line += "\t%s=%s" % (key, value)
    print(line)


class Handler:
    async def handle_DATA(self, server, session, envelope):
        response = DEFAULT_RESPONSE
        await asyncio.sleep(RESPONSE_DELAY)
        log(
            event="handle_DATA",
            peer=session.peer,
            mail_from=envelope.mail_from,
            rcpt_tos=envelope.rcpt_tos,
            response=response,
        )
        return response


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--port", type=int, default=8000)
    return parser.parse_args()


def main():
    args = parse_args()
    log(
        event="server started",
        listen_addr=LISTEN_ADDR,
        port=args.port,
        response_delay=RESPONSE_DELAY,
    )
    handler = Handler()
    controller = Controller(handler, hostname=LISTEN_ADDR, port=args.port)
    controller.start()
    input("SMTP server running. Press Return to stop server and exit.\n")
    controller.stop()
    log(event="server stopped")


if __name__ == "__main__":
    main()
