#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

timetail -r '^tskv\ttskv_format=mail-fan-send-log\ttimestamp=(\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d)' -n 60 /var/log/fan_send/typed.log | head -n -1 \
    | awk -v ts=$(date +%s) '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    BEGIN {
        duplicated = 0
        invalid = 0
        unsubscribed = 0
    }

    /type=send_task_processed/ {
        status = get_tskv_value($0, "status")
        send_tasks_statuses[status]++
        if (status == "success") {
            duplicated += get_tskv_value($0, "duplicated")
            invalid += get_tskv_value($0, "invalid")
            unsubscribed += get_tskv_value($0, "unsubsribed")
        }
    }

    /type=test_send_task_processed/ {
        status = get_tskv_value($0, "status")
        test_send_tasks_statuses[status]++
    }

    /type=mail_message_sent/ {
        status = get_tskv_value($0, "status")
        mail_sent_statuses[status]++
    }

    END {
        for (status in send_tasks_statuses) {
            print "send_tasks.statuses." status, send_tasks_statuses[status], ts
        }
        print "send_tasks.duplicated_emails", duplicated, ts
        print "send_tasks.invalid_emails", invalid, ts
        print "send_tasks.unsubscribed_emails", unsubscribed, ts
        for (status in test_send_tasks_statuses) {
            print "test_send_tasks.statuses." status, test_send_tasks_statuses[status], ts
        }
        for (status in mail_sent_statuses) {
            print "mail.sent.statuses." status, mail_sent_statuses[status], ts
        }
    }'
