#pragma once

#include <common/types.h>
#include <yplatform/json.h>
#include <yplatform/util/split.h>

namespace fan {

struct campaign
{
    int64_t id;
    string account_slug;
    string campaign_slug;
    string from_email;

    static campaign from_json(const yplatform::json_value& json)
    {
        campaign ret;
        ret.id = json["id"].to_int64();
        ret.account_slug = json["account_slug"].to_string();
        ret.campaign_slug = json["campaign_slug"].to_string();
        ret.from_email = json["from_email"].to_string();
        return ret;
    }
};

}
