#pragma once

#include "types.h"

namespace fan {

enum class error : int
{
    success = 0,
    tasks_api_error,
    send_error,
    test_send_error,
    no_recipients,

    COUNT
    // DO NOT FORGET TO EXTEND error_names
};

inline const std::string& error_message(error err)
{
    static constexpr std::initializer_list<const char*> names = {
        "success", "tasks api error", "send error", "test send error", "no recipients"
    };

    static_assert(
        names.size() == static_cast<size_t>(error::COUNT),
        "Error codes count doesn't correspond with error names count");
    static const std::vector<std::string> error_names(names.begin(), names.end());

    return error_names[static_cast<int>(err)];
}

}

namespace boost::system {

template <>
struct is_error_code_enum<fan::error>
{
    static const bool value = true;
};

}

namespace fan {

const boost::system::error_category& get_error_category();

inline error_code make_error_code(error e)
{
    return error_code(static_cast<int>(e), get_error_category());
}

}
