#pragma once

#include <common/types.h>
#include <yplatform/json.h>

namespace fan {

namespace detail {

inline map<string, string> parse_user_template_params(const yplatform::json_value& json)
{
    map<string, string> user_template_params;
    for (auto param_it = json.members_begin(); param_it != json.members_end(); ++param_it)
    {
        string param{ param_it.key() };
        string value = (*param_it).to_string();
        user_template_params[param] = value;
    }
    return user_template_params;
}

}

struct recipient_data
{
    string email;
    map<string, string> template_params;

    static recipient_data from_json(const yplatform::json_value& json)
    {
        recipient_data ret;
        if (json.is_string())
        {
            ret.email = json.to_string();
        }
        else
        {
            ret.email = json["email"].to_string();
            ret.template_params = detail::parse_user_template_params(json["user_template_params"]);
        }
        return ret;
    }
};

}
