#pragma once

#include <yplatform/find.h>
#include <yplatform/future/future.hpp>
#include <yplatform/future/multi_future.hpp>
#include <yplatform/time_traits.h>
#include <yplatform/util/weak_bind.h>
#include <yplatform/ptree.h>
#include <yplatform/task_context.h>
#include <boost/asio/io_service.hpp>
#include <boost/system/error_code.hpp>
#include <boost/serialization/strong_typedef.hpp>
#include <string>
#include <vector>
#include <map>
#include <unordered_set>
#include <memory>
#include <functional>
#include <exception>
#include <optional>
#include <atomic>
#include <mutex>

#define capture_self self = shared_from(this)

namespace fan {

using std::string;
using std::pair;
using std::vector;
using std::map;
using std::set;
using std::function;
using std::shared_ptr;
using std::make_shared;
using std::exception;
using std::runtime_error;
using std::optional;
using std::exception;
using std::function;
using std::atomic;
using std::mutex;
using std::lock_guard;
using boost::system::error_code;
using boost::asio::io_service;
using yplatform::task_context;
using yplatform::task_context_ptr;
using yplatform::future::future;
using yplatform::future::promise;
using yplatform::future::make_future;
using yplatform::shared_from;
using yplatform::weak_bind;
using yplatform::ptree;

using string_ptr = shared_ptr<string>;

using without_data_cb = function<void(error_code)>;
using string_ptr_cb = function<void(error_code, string_ptr)>;
using size_t_cb = function<void(error_code, size_t)>;

namespace ph = std::placeholders;
using namespace yplatform::time_traits;

template <typename Module, typename... Args>
auto find_module(Args&&... args)
{
    return yplatform::find<Module, shared_ptr>(std::forward<Args>(args)...);
}

}
