#pragma once

#include <common/types.h>

namespace fan::send {

struct polling_settings
{
    duration interval;
    size_t max_retries;
    double backoff_multiplier;

    static polling_settings from_ptree(const ptree& conf)
    {
        polling_settings ret;
        ret.interval = conf.get<duration>("interval");
        ret.max_retries = conf.get<size_t>("max_retries");
        ret.backoff_multiplier = conf.get<double>("backoff_multiplier");
        return ret;
    }
};

struct lease_settings
{
    size_t groups_count;
    size_t max_owned_groups;
    size_t extra_acquire_count;
    string send_resource_prefix;

    static lease_settings from_ptree(const ptree& conf)
    {
        lease_settings ret;
        ret.groups_count = conf.get<size_t>("groups_count");
        ret.max_owned_groups = conf.get<size_t>("max_owned_groups");
        ret.extra_acquire_count = conf.get<size_t>("extra_acquire_count");
        ret.send_resource_prefix = conf.get<string>("send_resource_prefix");
        return ret;
    }
};

struct settings
{
    polling_settings polling;
    optional<lease_settings> lease;

    static settings from_ptree(const ptree& conf)
    {
        settings ret;
        ret.polling = polling_settings::from_ptree(conf.get_child("polling"));
        if (auto lease_conf = conf.get_child_optional("lease"))
        {
            ret.lease = lease_settings::from_ptree(*lease_conf);
        }
        return ret;
    }
};

}
