#pragma once

#include <common/types.h>

namespace fan {

template <typename T>
vector<vector<T>> split_into_segments(const vector<T>& range, size_t segments_max_count)
{
    size_t segment_size = range.size() % segments_max_count == 0 ?
        range.size() / segments_max_count :
        range.size() / segments_max_count + 1;

    vector<vector<T>> splitted_range;
    for (size_t begin_idx = 0; begin_idx < range.size(); begin_idx += segment_size)
    {
        size_t end_idx = std::min(begin_idx + segment_size, range.size());
        splitted_range.emplace_back(range.begin() + begin_idx, range.begin() + end_idx);
    }

    return splitted_range;
}

}
