#pragma once

#include <common/test_send_task.h>
#include <common/campaign.h>
#include <common/recipient_data.h>
#include <common/send_stats.h>
#include <common/types.h>

namespace fan::tasks {

struct send_tasks
{
    using campaigns_cb = function<void(error_code, const vector<campaign>&)>;
    using recipients_cb = function<void(error_code, const vector<recipient_data>&)>;
    using strings_cb = function<void(error_code, const vector<string>&)>;

    virtual ~send_tasks() = default;

    virtual void get_pending_campaigns(
        task_context_ptr ctx,
        size_t count,
        const campaigns_cb& cb) = 0;

    virtual void get_campaign_recipients(
        task_context_ptr ctx,
        const campaign& campaign,
        const recipients_cb& cb) = 0;

    virtual void get_campaign_unsubscribe_list(
        task_context_ptr ctx,
        const campaign& campaign,
        const strings_cb& cb) = 0;

    virtual void get_campaign_eml_template(
        task_context_ptr ctx,
        const campaign& campaign,
        const string_ptr_cb& cb) = 0;

    virtual void get_campaign_template_params(
        task_context_ptr ctx,
        const campaign& campaign,
        const vector<recipient_data>& recipients,
        const recipients_cb& cb) = 0;

    virtual void mark_campaign_sent(
        task_context_ptr ctx,
        const campaign& campaign,
        const send_stats& stats,
        const without_data_cb& cb) = 0;

    virtual void mark_campaign_failed(
        task_context_ptr ctx,
        const campaign& campaign,
        const string& reason,
        const without_data_cb& cb) = 0;
};

}
