#pragma once

#include <common/mail_message.h>
#include <common/campaign.h>
#include <common/test_send_task.h>
#include <common/types.h>
#include <yplatform/log.h>
#include <boost/algorithm/string/join.hpp>

namespace fan::typed {

namespace tl = yplatform::log::typed;

namespace detail {

inline tl::attributes_map make_attrs_map(const map<string, string>& attrs)
{
    tl::attributes_map ret;
    for (auto [key, value] : attrs)
    {
        ret << tl::make_attr(key, value);
    }
    return ret;
}

}

inline void log_campaign_processed(
    task_context_ptr ctx,
    const campaign& campaign,
    const string& status,
    const string& reason,
    const map<string, string>& extra_attrs = {})
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    YLOG(log, info) << tl::make_attr("type", "send_task_processed")
                    << tl::make_attr("status", status) << tl::make_attr("reason", reason)
                    << tl::make_attr("y_context", ctx->uniq_id())
                    << tl::make_attr("account_slug", campaign.account_slug)
                    << tl::make_attr("campaign_slug", campaign.campaign_slug)
                    << detail::make_attrs_map(extra_attrs);
}

inline void log_segment_processed(
    task_context_ptr ctx,
    const campaign& campaign,
    const string& status,
    const string& reason,
    const map<string, string>& extra_attrs = {})
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    YLOG(log, info) << tl::make_attr("type", "segment_processed") << tl::make_attr("status", status)
                    << tl::make_attr("reason", reason) << tl::make_attr("y_context", ctx->uniq_id())
                    << tl::make_attr("account_slug", campaign.account_slug)
                    << tl::make_attr("campaign_slug", campaign.campaign_slug)
                    << detail::make_attrs_map(extra_attrs);
}

inline void log_test_send_task_processed(
    task_context_ptr ctx,
    const test_send_task& task,
    const string& status,
    const string& reason,
    const map<string, string>& extra_attrs = {})
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    YLOG(log, info) << tl::make_attr("type", "test_send_task_processed")
                    << tl::make_attr("status", status) << tl::make_attr("reason", reason)
                    << tl::make_attr("y_context", ctx->uniq_id())
                    << tl::make_attr("task_id", task.id)
                    << tl::make_attr("account_slug", task.account_slug)
                    << tl::make_attr("campaign_slug", task.campaign_slug)
                    << tl::make_attr("recipients", boost::algorithm::join(task.recipients, ","))
                    << detail::make_attrs_map(extra_attrs);
}

inline void log_mail_message_sent(
    task_context_ptr ctx,
    const string& status,
    const string& reason,
    const string& smtp_response,
    const mail_message& message,
    const string& reverse_path)
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    YLOG(log, info) << tl::make_attr("type", "mail_message_sent") << tl::make_attr("status", status)
                    << tl::make_attr("reason", reason) << tl::make_attr("y_context", ctx->uniq_id())
                    << tl::make_attr("smtp_response", smtp_response)
                    << tl::make_attr("from_email", message.from_email)
                    << tl::make_attr("reverse_path", reverse_path)
                    << tl::make_attr("recipient", message.recipient)
                    << tl::make_attr("account_slug", message.account_slug)
                    << tl::make_attr("campaign_slug", message.campaign_slug);
}

}
