## КРАТКО

Django_yauth -- это подключаемое приложение для Django-проектов, реализующее
Яндекс- и доменную авторизацию.

Страница на wiki: http://wiki.yandex-team.ru/Python/common/djangoyauth

Приложение умеет:

- определять UID пользователя из браузерной cookie
- перенаправлять браузер на Паспорт для подновления и логина
- доставать логин пользователя (пока только его, остальное добавится по мере
  необходимости)
- требовать залогиненного пользователя для view
- подключать к пользователю произвольные профайлы чужих приложений


## УСТАНОВКА

1.  Счекаутить папку с приложением, положить куда-нибудь в питоновский путь.
    Прямо в проект класть не рекомендуется, потому что ее тогда придется
    коммитить в репозиторий проекта и следить за актуальностью самостоятельно.

    Альтернативно -- установить пакет `django_yauth` c локального PyPI или deb-пакет `python-django-yauth`.

2.  Прописать установленный пакет в INSTALLED_APPS:

        INSTALLED_APPS = (
           # ...
           'django_yauth',
        )

    Это приложение должно стоять раньше стандартного "django.contrib.auth",
    чтобы перекрывать шаблон логинной формы в админку, которая в django_yauth
    перенаправлена в Яндекс.Паспорт. Это нужно, если вы собираетесь использовать
    Яндекс-авторизацию в админке.

3.  В проектных setting'ах включить settings.py от django_yauth:

        from django_yauth.settings import *

    Это необходимо, потому что код завязан на обязательное наличие некоторых
    setting'ов.

4.  После этого импорта указать тип авторизации (intranet, mobile или desktop)
    для настройки URL'ов к Паспорту. Пример для внутренней авторизации:

        YAUTH_TYPE = 'intranet' # по умолчанию - None, т.е. автоопределение

    Для динамического определения версии можно установливать request.yauth_type
    в необходимое значение.

5.  Убедиться, что модуль `yenv` выдаёт правильное окружение для выбора
    сервера blackbox. Снова пример для внутренней авторизации:

        $ python -c "import yenv; print yenv.name"
        intranet

    (Если выдача отличается, а нужна внутренняя авторизация, поставьте пакет
    yandex-environment-intranet).

Авторизация внешних и внутренних пользователей отличается только URL'ами к
Паспорту и blackbox'у. Дальнейшие настройки применимы и к внутренней, и к
внешней авторизации.

Один из способов авторизации в Django-админке описан в последнем разделе.


## АВТОРИЗАЦИЯ ЯНДЕКС-ПОЛЬЗОВАТЕЛЕЙ В ПРИЛОЖЕНИИ

Авторизация включается через middleware:

        MIDDLEWARE_CLASSES = (
            # ...
            'django_yauth.middleware.YandexAuthMiddleware',
        )

После подключения, middleware начинает определять, является ли пользователь
залогиненным в Яндекс или нет. При необходимости делает редиректы на Паспорт
для подновления cookie (отключаемо в настройках).

Для указания домена, который передаётся для авторизации в Паспорт, можно
включить contrib-приложение sites и установить текущий сайт на
*.yandex[-team].ru (в зависимости от авторизации - внутренней или внешней).
Если sites не установлен (или в settings указано `YAUTH_USE_SITES = False`),
текущий сайт будет взят из request.

В объектах request появляется свойство request.yauser со следующими свойствами:

- request.yauser.is_authenticated() -- признак авторизованности
- request.yauser.uid -- UID (только у авторизованных)
- request.yauser.login -- логин (у неавторизованных это строка-заглушка)

В приложении есть декоратор yalogin_required, которым можно закрыть view, чтобы
она была доступна только авторизованным пользователям:

    from django_yauth.decorators import yalogin_required

    @yalogin_required
    def my_secret_view(request):
        # ...

Если пользователь не залогинен, он будет отослан на Паспорт.

Различные настройки подробно описаны в settings.py. Изменять их только нужно
не в нем самом, а в настройках проекта после строчки с импортом настроек
django_yauth.


### Дополнительные поля

Если используется blackbox'овый бэкенд, то django_yauth умеет выдавать
дополнительные поля, связанные с юзером. На все поля, которые нужны проекту,
он должен иметь административный доступ в Паспорте. Именно поэтому поля, нужные
проекту не зашиты в код навечно, а оформлены настройкой YAUTH_PASSPORT_FIELDS. Это
список названий запрашиваемых полей. Справочник по полям есть здесь:
<https://wiki.yandex.ru/passport/BlackboxDbFields>


### Lite-пользователя

В Яндексе есть так называемые лайт-пользователи <http://wiki.yandex-team.ru/passport/Lite>.
Информацию о них можно получить от blackbox. Они тоже имеют uid'ы, которые
не пересекаются с uid'ами обычных пользователей.

Поскольку они не равны в правах с обычными яндексовыми пользователями, то в рамках
django_yauth они всегда считаются не авторизованымы, т.е. is_authenticated()
возвращает False.

Для идентификации лайт-пользователей у yuser есть метод is_light().

### Профайлы

В собственных проектах можно определять свои модели, которые будут профайлами
пользователей. Это удобно, когда к базовой информации о пользователе нужно
добавить что-то специфичное для приложения. Делается это в настройках:

    YAUTH_YAUSER_PROFILES = (
        'myapp.Profile',
        'myapp2.Profile',
    )

Строчки представляют собой пары "имяприложения.Модель". Модель должна
удовлетворять двум требованиям:

- иметь поле yandex_uid, в котором будет яндексовый UID
- уметь создаваться без других дополнительных данных, то есть все остальные
  поля должны либо уметь оставать пустыми, либо иметь значения по умолчанию

Профайлы эти будут доступны из объекта request.yauser:

    request.yauser.myapp_profile
    request.yauser.myapp2_profile

Профайлы достаются из базы по первому к ним обращению, а если записи в базе еще
нет, то она автоматически создается. При этом, если у объекта профайла есть метод
profile_created, то он вызывается при первом создании профайла. Это удобно
использовать для каких-нибудь дополнительных регистрирующих действий.


### Пользователи в шаблонах

Почти наверняка вы захотите отображать пользователя в шаблонах приложения, для чего
нужно подключить соответствующий процессор контекста:

        TEMPLATE_CONTEXT_PROCESSORS = (
            # ...
            'django_yauth.context.yauth',
        )

Установить приложение django_template_common (поставив сначала пакет
python-django-template-common):

        INSTALLED_APPS = (
            # ...
            'django_template_common',
        )

В шаблоне подключить библиотеку:

        {% load yauth}

И использовать шаблонные теги:

- `{% yauth %}` -- стандартная верстка текущего юзера и всех нужных ссылок для шапки
- `{% login_form %}` -- всплывающая форма логина

(Ещё нужно скопировать к себе в проект и использовать yauth.css из папки css в
django_yauth.)

Кроме тегов, в шаблоне появляется переменная `yauth` с текущим пользователем, а также
переменные с URL'ами Паспорта:

- login_url: форма логина
- logout_url: логаут
- register_url: процесс регистрации
- account_url: общеяндексовый аккаунт пользователя (http://i.yandex.ru/)
- passport_account_url: аккаунт пользователя в Паспорте

Ещё в контексте появляется переменная passport_host, которой пользуется python-django-lego2, чтобы
в лего-шапке были правильные адреса до паспорта.


### Blackbox

Яндекс-авторизация django_yauth работает через авторизационный бэкенд --
[Blackbox][1].

- Blackbox умеет узнавать пользователя по куке Session_id и по паре
  логин/пароль. Также умеет выдавать расширенную личную информацию пользователя
  (ФИО, email), для чего требует специальных дырок и прав.

[1]: https://wiki.yandex.ru/passport/blackbox


## ИСПОЛЬЗОВАНИЕ НАТИВНОГО DJANGO USER

Этот режим был сделан специально для elephantum@ :-). Заключается он
в том, что вместо встроенной авторизации для определения `request.user` используется
текущий залогиненный пользователь Яндекса. Его также пускают в админку в том случае,
если существует (заведен вручуную) Джанго-пользователь с таким же логином, и у него
есть права на логин в админку (`is_staff = True`).

Этот режим по умолчанию отключен и включается настройкой `YAUTH_USE_NATIVE_USER`.

При его использовании надо убедиться, что `YandexAuthMiddleware` стоит в
настройках **вместо** стандартной `AuthenticationMiddleware`, потому что она
переписывает под себя `request.user`.

Замечание: Раньше можно было не удалять стандартную middleware, поместив
YandexAuthMiddleware после него. Но, начиная с пакета python-django версии
1.3-20110901.svn16714-yandex1, `YAUTH_USE_NATIVE_USER = True` не работает при
включенной `AuthenticationMiddleware`.

Для авторизованного через django_yauth пользователя есть возможность
автоматически создавать и сохранять в БД объект User при обращении к
`request.user`. Регулируется переменной settings.YAUTH_CREATE_USER_ON_ACCESS
(по-умолчанию `False`).

Параметр `YAUTH_YAUSER_USERNAME_FIELD` указывает, какое поле yauser будет
ставится в соответствие `USERNAME_FIELD` джанго пользователя (по умолчанию `login`).
`uid` позволяет одновременно работать с внутренним и внешним Паспортом,
где `login` может совпадать.
Нужно учитывать, что поле должно быть уникальным, и что стандартный
auth.User не поддерживает 64-битный яндексовый uid.

При создании джанго пользователя можно сохранять произвольные поля yauser.
Это задается настройкой `YAUTH_USER_EXTRA_FIELDS`, которая хранит список пар вида
(yauser_field, user_field). Содержимое user_field нового User будет взято из
yauser_field яндексового пользователя.


## РАБОТА В MASTER/SLAVE РЕЖИМЕ БД

Использование `django_replicated` и опции `YAUTH_CREATE_USER_ON_ACCESS` и/или
`YAUTH_CREATE_PROFILE_ON_ACCESS` приводят к тому, что пользователь и/или профиль
пытаются создаваться даже на GET/HEAD запросах, которые обычно идут на slave базу.

Для того чтобы это обойти, существует специальный редирект (если запрос GET/HEAD)
на отдельную вьюху (имя который в настройке `YAUTH_CREATE_PROFILE_VIEW`),
которая создаёт пользователя и/или все нужные профили. Чтобы его включить
нужно выставить `YAUTH_CREATION_REDIRECT` в `True`, и не забыть в настройках
`django_replicated` указать для данной вьюхи форсирование хождение в master.

Особенность использования `YAUTH_CREATION_REDIRECT` состоит в том, что этот
механизм провоцирует "проверочные" запросы в базу за пользователем и/или профилями,
чтобы удостовериться, что они уже есть и не нужен редирект.

## Тестирование

Для того чтобы в тестах можно было удобно переопределять пользователя или приложение
нужно заменить `YandexAuthMiddleware` на `YandexAuthTestMiddleware` и выставить
настройку `YAUTH_TEST_USER` и `YAUTH_TEST_APPLICATION` (если требуется OAuth
аутентификация).
