from django.contrib.auth.models import AnonymousUser
from rest_framework.authentication import BasicAuthentication
from fan.utils.tvm import TVM_CFG_WITH_DAEMON


class TvmServiceAnonymousUser(AnonymousUser):
    def __init__(self, source_id):
        super().__init__()
        self.source_id = source_id

    def __str__(self):
        return "TVM Service Anonymous User: %s" % self.source_id

    def is_authenticated(self):
        return True


class TVMAuthentication(BasicAuthentication):
    @staticmethod
    def _get_source_service_id(request):
        check_result = TVM_CFG_WITH_DAEMON.check_service_ticket(
            service_ticket=request.META.get("HTTP_X_YA_SERVICE_TICKET")
        )
        return check_result and check_result.src

    def authenticate(self, request):
        source_id = TVMAuthentication._get_source_service_id(request)
        if source_id is None:
            return None
        return TvmServiceAnonymousUser(source_id), None
