from .common import *
from fan.accounts.organizations.limits import default_send_emails_limit, set_send_emails_limit
from fan_ui.api.query_params import pass_org_id_param, pass_limit_value_param


class LimitEndpoint(Endpoint):
    permission_classes = (IsAuthenticated, ApiOrganizationTvmServicePermission)

    @method_decorator(pass_org_id_param)
    @method_decorator(pass_limit_value_param)
    def put(self, request, org_id, value):
        value = value if value != 0 else default_send_emails_limit()
        set_send_emails_limit(org_id, value)
        return Response(status=status.HTTP_200_OK)
