from .common import *
from fan.accounts.organizations.limits import set_trusty
from fan_ui.api.query_params import pass_org_id_param, pass_trusty_value_param


class TrustyEndpoint(Endpoint):
    permission_classes = (IsAuthenticated, ApiOrganizationTvmServicePermission)

    @method_decorator(pass_org_id_param)
    @method_decorator(pass_trusty_value_param)
    def put(self, request, org_id, value):
        set_trusty(org_id, value)
        return Response(status=status.HTTP_200_OK)
