from .common import *
from django.http import HttpResponse
from fan.message.render import render_eml
from fan_ui.api.query_params import (
    pass_account_object,
    pass_campaign_object,
)


class CampaignEMLTemplateEndpoint(Endpoint):
    permission_classes = ()

    @method_decorator(pass_account_object)
    @method_decorator(pass_campaign_object)
    def get(self, request, account, campaign, **kwargs):
        eml = render_eml(campaign)
        return HttpResponse(eml)
