from .common import *
from django.http import JsonResponse
from django.conf import settings
from fan_ui.api.query_params import pass_account_object, pass_campaign_object
from fan_ui.api.exceptions import ValidationError
from fan.message.render import generate_rendering_params
from fan.utils.emails import is_valid


class CampaignTemplateParamsEndpoint(Endpoint):
    permission_classes = ()

    @method_decorator(pass_account_object)
    @method_decorator(pass_campaign_object)
    def get(self, request, account, campaign):
        recipients = self._get_recipients_param(request)
        self._validate_recipients(recipients)
        campaign_id = campaign.id
        letter_id = campaign.default_letter.id
        result = []
        for recipient in recipients:
            result.append(generate_rendering_params(campaign_id, letter_id, recipient))
        return JsonResponse(result, safe=False)

    def _get_recipients_param(self, request):
        if "recipients" not in request.data:
            raise ValidationError({"recipients": "not_found"})
        recipients = request.data["recipients"]
        if not isinstance(recipients, list):
            raise ValidationError({"recipients": "invalid_type"})
        return recipients

    def _validate_recipients(self, recipients):
        if len(recipients) > settings.MAX_MAILLIST_RECIPIENTS:
            raise ValidationError({"recipients": "too_long"})
        for recipient in recipients:
            if not is_valid(recipient):
                raise ValidationError({"recipients": "invalid_email"})
