from .common import *
from django.http import JsonResponse
from fan_ui.api.query_params import pass_account_object, pass_campaign_object
from fan.lists.unsubscribed import get_unsubscribed_emails_for_campaign


class CampaignUnsubscribeListEndpoint(Endpoint):
    permission_classes = ()

    @method_decorator(pass_account_object)
    @method_decorator(pass_campaign_object)
    def get(self, request, account, campaign):
        emails = get_unsubscribed_emails_for_campaign(campaign)
        return JsonResponse(list(emails), safe=False)
