from .common import *
from fan.campaigns.list import get_campaigns_to_send
from fan_ui.api.query_params import pass_count_param
from fan_ui.api.serializers.campaign import PendingCampaignSerializerV1


class PendingCampaignListEndpoint(Endpoint):
    permission_classes = ()

    @method_decorator(pass_count_param)
    def get(self, request, count, **kwargs):
        campaigns = get_campaigns_to_send(count)
        return make_ok_response(campaigns, PendingCampaignSerializerV1)
